Define CONF_WORD = 0x31c4
AllDigital
ANSEL = 0x07
CMCON = 0x07
'program servo motor
'print MGV115V1.1
'potmeters:
'P1   speed connected to GPIO 0
'P2   angle connected to GPIO 1
'P3   Interval connected to GPIO2
'jumper connected to GPIO3
'Input start/stop connected to GPIO4
	TRISIO = %011111
	Dim counter As Byte
	Dim speed As Byte
	Dim minimum_angle As Byte
	Dim maximum_angle As Byte
	Dim interval As Byte
	Dim advalue As Word
	Dim direction As Byte
	direction = 0
main:
	Gosub measure_speed
	Gosub measure_interval
	Gosub measure_angle
	If GPIO.3 = 0 Then          'jumper set to continious movement
		If GPIO.4 = 0 Then          'wait for input
			Gosub move_right
			Gosub interval_loop
			Gosub move_left
			Gosub interval_loop
		Endif
	Else          'single move action
		If GPIO.4 = 0 Then          'Input active
			If direction = 0 Then          'make move only once
				direction = 1
				Gosub move_right
			Endif
		Else          'nput Not active
			If direction = 1 Then          'make move only once
				direction = 0
				Gosub move_left
			Endif
		Endif
	Endif
	Goto main

End                                               

measure_speed:

	Adcin 0, advalue          'measure pot 1 for speed
	advalue = advalue / 5          'this will make a runtime between fastest and ca. 20 x 20 mSeconds
	speed = advalue.LB
	If speed < 10 Then          'limit max speed
		speed = 10
	Endif
Return                                            
measure_interval:
	Adcin 2, advalue          'measure pot 3 for interval
	advalue = advalue / 5          'making an interval between 0 and (200 x 0,1) secs
	interval = advalue.LB
Return                                            
measure_angle:
	Adcin 1, advalue          'measure pot 2 for angle
	If advalue > 990 Then          'limit to 990
		advalue = 990
	Endif
	advalue = advalue / 10          'needing no more than 2 x 99 steps from center
	If advalue < 10 Then          'minimum angle = 10%
		advalue = 10
	Endif
	counter = advalue          'conversion word to byte
	minimum_angle = 150 - counter          'calculate from center i.e. 51 to 150
	maximum_angle = 150 + counter          'calculate from center i.e. 150 to 249
'values are limitied between 51 and 249 to avoid high current in servo
Return                                            
move_left:
	For counter = minimum_angle To maximum_angle
		ServoOut GPIO.5, counter
		WaitMs speed
	Next counter
Return                                            
move_right:
	For counter = maximum_angle To minimum_angle Step -1
		ServoOut GPIO.5, counter
		WaitMs speed
	Next counter
Return                                            
interval_loop:
	If interval > 0 Then
		For counter = 1 To interval
			WaitMs 100
		Next counter
	Endif
Return                                            
