	list p=12f675
	#include <p12f675.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC12F675
; Clock frequency: 4.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0008
	ORG 0x0004
	RETFIE
L0008:
; 1: Define CONF_WORD = 0x31c4
; 2: AllDigital
	BSF STATUS,RP0
	CLRF 0x1F
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF 0x19
; 3: ANSEL = 0x07
	BSF STATUS,RP0
	MOVLW 0x07
	MOVWF 0x1F
; 4: CMCON = 0x07
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF 0x19
; 5:  'program servo motor
; 6:  'print MGV115V1.1
; 7:  'potmeters:
; 8:  'P1   speed connected to GPIO 0
; 9:  'P2   angle connected to GPIO 1
; 10:  'P3   Interval connected to GPIO2
; 11:  'jumper connected to GPIO3
; 12:  'Input start/stop connected to GPIO4
; 13: TRISIO = %011111
	BSF STATUS,RP0
	MOVLW 0x1F
	MOVWF 0x05
	BCF STATUS,RP0
; 14: Dim counter As Byte
;       The address of 'counter' is 0x2C
	counter EQU 0x2C
; 15: Dim speed As Byte
;       The address of 'speed' is 0x2D
	speed EQU 0x2D
; 16: Dim minimum_angle As Byte
;       The address of 'minimum_angle' is 0x2E
	minimum_angle EQU 0x2E
; 17: Dim maximum_angle As Byte
;       The address of 'maximum_angle' is 0x2F
	maximum_angle EQU 0x2F
; 18: Dim interval As Byte
;       The address of 'interval' is 0x30
	interval EQU 0x30
; 19: Dim advalue As Word
;       The address of 'advalue' is 0x31
	advalue EQU 0x31
; 20: Dim direction As Byte
;       The address of 'direction' is 0x33
	direction EQU 0x33
; 21: direction = 0
	CLRF 0x33
; 22: main: 
L0001:
; 23: Gosub measure_speed
	CALL L0002
; 24: Gosub measure_interval
	CALL L0003
; 25: Gosub measure_angle
	CALL L0004
; 26: If GPIO.3 = 0 Then 'jumper set to continious movement
	BTFSC 0x05,3
	GOTO L0009
; 27: If GPIO.4 = 0 Then 'wait for input
	BTFSC 0x05,4
	GOTO L0010
; 28: Gosub move_right
	CALL L0006
; 29: Gosub interval_loop
	CALL L0007
; 30: Gosub move_left
	CALL L0005
; 31: Gosub interval_loop
	CALL L0007
; 32: Endif
L0010:	MOVLW 0x1F
	ANDWF STATUS,F
; 33: Else 'single move action
	GOTO L0011
L0009:	MOVLW 0x1F
	ANDWF STATUS,F
; 34: If GPIO.4 = 0 Then 'Input active
	BTFSC 0x05,4
	GOTO L0012
; 35: If direction = 0 Then 'make move only once
	MOVF 0x33,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0013
; 36: direction = 1
	MOVLW 0x01
	MOVWF 0x33
; 37: Gosub move_right
	CALL L0006
; 38: Endif
L0013:	MOVLW 0x1F
	ANDWF STATUS,F
; 39: Else 'nput Not active
	GOTO L0014
L0012:	MOVLW 0x1F
	ANDWF STATUS,F
; 40: If direction = 1 Then 'make move only once
	MOVF 0x33,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0015
; 41: direction = 0
	CLRF 0x33
; 42: Gosub move_left
	CALL L0005
; 43: Endif
L0015:	MOVLW 0x1F
	ANDWF STATUS,F
; 44: Endif
L0014:	MOVLW 0x1F
	ANDWF STATUS,F
; 45: Endif
L0011:	MOVLW 0x1F
	ANDWF STATUS,F
; 46: Goto main
	GOTO L0001
; 47: 
; 48: End
L0016:	GOTO L0016
; 49: 
; 50: measure_speed: 
L0002:
; 51: 
; 52: Adcin 0, advalue 'measure pot 1 for speed
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	MOVLW 0x00
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x31
	MOVF ADRESH,W
	MOVWF 0x32
; 53: advalue = advalue / 5 'this will make a runtime between fastest and ca. 20 x 20 mSeconds
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x05
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x31
	MOVF R0H,W
	MOVWF 0x32
; 54: speed = advalue.LB
	MOVF 0x31,W
	MOVWF 0x2D
; 55: If speed < 10 Then 'limit max speed
	MOVLW 0x0A
	SUBWF 0x2D,W
	BTFSC STATUS,C
	GOTO L0017
; 56: speed = 10
	MOVLW 0x0A
	MOVWF 0x2D
; 57: Endif
L0017:	MOVLW 0x1F
	ANDWF STATUS,F
; 58: Return
	RETURN
; 59: measure_interval: 
L0003:
; 60: Adcin 2, advalue 'measure pot 3 for interval
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	MOVLW 0x02
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x31
	MOVF ADRESH,W
	MOVWF 0x32
; 61: advalue = advalue / 5 'making an interval between 0 and (200 x 0,1) secs
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x05
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x31
	MOVF R0H,W
	MOVWF 0x32
; 62: interval = advalue.LB
	MOVF 0x31,W
	MOVWF 0x30
; 63: Return
	RETURN
; 64: measure_angle: 
L0004:
; 65: Adcin 1, advalue 'measure pot 2 for angle
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	MOVLW 0x01
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x31
	MOVF ADRESH,W
	MOVWF 0x32
; 66: If advalue > 990 Then 'limit to 990
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xDE
	CALL C003
	BTFSS STATUS,Z
	GOTO L0018
; 67: advalue = 990
	MOVLW 0xDE
	MOVWF 0x31
	MOVLW 0x03
	MOVWF 0x32
; 68: Endif
L0018:	MOVLW 0x1F
	ANDWF STATUS,F
; 69: advalue = advalue / 10 'needing no more than 2 x 99 steps from center
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x31
	MOVF R0H,W
	MOVWF 0x32
; 70: If advalue < 10 Then 'minimum angle = 10%
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	CALL C004
	BTFSS STATUS,Z
	GOTO L0019
; 71: advalue = 10
	MOVLW 0x0A
	MOVWF 0x31
	CLRF 0x32
; 72: Endif
L0019:	MOVLW 0x1F
	ANDWF STATUS,F
; 73: counter = advalue 'conversion word to byte
	MOVF 0x31,W
	MOVWF 0x2C
; 74: minimum_angle = 150 - counter 'calculate from center i.e. 51 to 150
	MOVF 0x2C,W
	SUBLW 0x96
	MOVWF 0x2E
; 75: maximum_angle = 150 + counter 'calculate from center i.e. 150 to 249
	MOVLW 0x96
	ADDWF 0x2C,W
	MOVWF 0x2F
; 76:  'values are limitied between 51 and 249 to avoid high current in servo
; 77: Return
	RETURN
; 78: move_left: 
L0005:
; 79: For counter = minimum_angle To maximum_angle
	MOVF 0x2E,W
	MOVWF 0x2C
L0020:
	MOVF 0x2C,W
	SUBWF 0x2F,W
	BTFSS STATUS,C
	GOTO L0021
; 80: ServoOut GPIO.5, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0023
	BSF GPIO,5
L0022:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0022
	BCF GPIO,5
L0023:
; 81: WaitMs speed
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 82: Next counter
	MOVLW 0x01
	ADDWF 0x2C,F
	BTFSS STATUS,C
	GOTO L0020
L0021:	MOVLW 0x1F
	ANDWF STATUS,F
; 83: Return
	RETURN
; 84: move_right: 
L0006:
; 85: For counter = maximum_angle To minimum_angle Step -1
	MOVF 0x2F,W
	MOVWF 0x2C
L0024:
	MOVF 0x2E,W
	SUBWF 0x2C,W
	BTFSS STATUS,C
	GOTO L0025
; 86: ServoOut GPIO.5, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0027
	BSF GPIO,5
L0026:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0026
	BCF GPIO,5
L0027:
; 87: WaitMs speed
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 88: Next counter
	MOVLW 0x01
	SUBWF 0x2C,F
	BTFSC STATUS,C
	GOTO L0024
L0025:	MOVLW 0x1F
	ANDWF STATUS,F
; 89: Return
	RETURN
; 90: interval_loop: 
L0007:
; 91: If interval > 0 Then
	MOVF 0x30,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0028
; 92: For counter = 1 To interval
	MOVLW 0x01
	MOVWF 0x2C
L0029:
	MOVF 0x2C,W
	SUBWF 0x30,W
	BTFSS STATUS,C
	GOTO L0030
; 93: WaitMs 100
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
	CALL W001
; 94: Next counter
	MOVLW 0x01
	ADDWF 0x2C,F
	BTFSS STATUS,C
	GOTO L0029
L0030:	MOVLW 0x1F
	ANDWF STATUS,F
; 95: Endif
L0028:	MOVLW 0x1F
	ANDWF STATUS,F
; 96: Return
	RETURN
; End of program
L0031:	GOTO L0031
; Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	MOVF R0L,W
	RETURN
; Comparison Routine
C001:	MOVWF R1L
	MOVLW 0x05
	GOTO C007
C002:	MOVWF R1L
	MOVLW 0x02
	GOTO C007
C003:	MOVWF R1L
	MOVLW 0x06
	GOTO C007
C004:	MOVWF R1L
	MOVLW 0x03
	GOTO C007
C005:	MOVWF R1L
	MOVLW 0x04
	GOTO C007
C006:	MOVWF R1L
	MOVLW 0x01
	GOTO C007
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine - Byte Argument
X001:	MOVLW 0x0A
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x06
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
