; Compiled with: PIC Simulator IDE v6.86
; Microcontroller model: PIC12F675
; Clock frequency: 4.0 MHz
;
;       The address of 'program' (byte) (global) is 0x2D
	program EQU 0x2D
;       The address of 'program_enable' (bit) (global) is 0x2C,0
;       The address of 'dummy' (byte) (global) is 0x2E
	dummy EQU 0x2E
;       The address of 'counter' (byte) (global) is 0x2F
	counter EQU 0x2F
;       The address of 'counter2' (byte) (global) is 0x30
	counter2 EQU 0x30
;       The address of 'result' (byte) (global) is 0x31
	result EQU 0x31
;       The address of 'led1' (byte) (global) is 0x32
	led1 EQU 0x32
;       The address of 'led2' (byte) (global) is 0x33
	led2 EQU 0x33
;       The address of 'led3' (byte) (global) is 0x34
	led3 EQU 0x34
;       The address of 'led4' (byte) (global) is 0x35
	led4 EQU 0x35
;       The address of 'on_time' (byte) (global) is 0x36
	on_time EQU 0x36
;       The address of 'off_time' (byte) (global) is 0x37
	off_time EQU 0x37
;       The value of 'maxprogram' (global) is 11
; Procedure declaration: Proc set_ports(program As Byte)
;       The address of 'program' (byte) (set_ports) is 0x38
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0003
	ORG 0x0004
	RETFIE
; Begin of program
L0003:
; 1: Define CONF_WORD = 0x31c4
; 2: Dim program As Byte
; 3: Dim program_enable As Bit
; 4: Dim dummy As Byte
; 5: Dim counter As Byte
; 6: Dim counter2 As Byte
; 7: Dim result As Byte
; 8: Dim led1 As Byte
; 9: Dim led2 As Byte
; 10: Dim led3 As Byte
; 11: Dim led4 As Byte
; 12: Dim on_time As Byte
; 13: Dim off_time As Byte
; 14: Const maxprogram = 11
; 15: TRISIO = %001000
	BSF STATUS,RP0
	MOVLW 0x08
	MOVWF 0x05
; 16: AllDigital
	CLRF 0x1F
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF 0x19
; 17: GPIO = 63
	MOVLW 0x3F
	MOVWF 0x05
; 18: Read 0, program 'get actual program from eeprom
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x2D
; 19: If program > maxprogram Then
	MOVF 0x2D,W
	SUBLW 0x0B
	BTFSC STATUS,C
	GOTO L0004
; 20: 	program = maxprogram
	MOVLW 0x0B
	MOVWF 0x2D
; 21: Endif
L0004:
; 22: GPIO = %000000
	CLRF 0x05
; 23: Call set_ports(program)
	MOVF 0x2D,W
	MOVWF 0x38
	CALL L0002
; 24: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 25: program_enable = 0
	BCF 0x2C,0
; 26: dummy = 1
	MOVLW 0x01
	MOVWF 0x2E
; 27: main:
L0001:
; 28: While dummy = 1 'endless loop
L0005:
	MOVF 0x2E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0006
; 29: 	led1 = led1 + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 30: 	led2 = led2 + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 31: 	led3 = led3 + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 32: 	led4 = led4 + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 33: 	
; 34: 	Select Case program
; 35: 	Case 1 'night rider
	MOVF 0x2D,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0007
; 36: 		Select Case led1
; 37: 		Case 0, 8
	MOVF 0x32,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0010
	GOTO L0009
L0010:
	MOVF 0x32,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0008
L0009:
; 38: 			GPIO = %010000
	MOVLW 0x10
	MOVWF 0x05
; 39: 			WaitMs 50
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 40: 		Case 1, 7
	GOTO L0011
L0008:
	MOVF 0x32,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0014
	GOTO L0013
L0014:
	MOVF 0x32,W
	SUBLW 0x07
	BTFSS STATUS,Z
	GOTO L0012
L0013:
; 41: 			GPIO = %000100
	MOVLW 0x04
	MOVWF 0x05
; 42: 		Case 2, 6
	GOTO L0015
L0012:
	MOVF 0x32,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0018
	GOTO L0017
L0018:
	MOVF 0x32,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0016
L0017:
; 43: 			GPIO = %000010
	MOVLW 0x02
	MOVWF 0x05
; 44: 		Case 3, 5
	GOTO L0019
L0016:
	MOVF 0x32,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0022
	GOTO L0021
L0022:
	MOVF 0x32,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0020
L0021:
; 45: 			GPIO = %000001
	MOVLW 0x01
	MOVWF 0x05
; 46: 		Case 4
	GOTO L0023
L0020:
	MOVF 0x32,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0024
; 47: 			GPIO = %100000
	MOVLW 0x20
	MOVWF 0x05
; 48: 			WaitMs 50
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 49: 		Case Else
	GOTO L0025
L0024:
; 50: 			led1 = 0
	CLRF 0x32
; 51: 		EndSelect
L0025:
L0023:
L0019:
L0015:
L0011:
; 52: 		WaitMs 100
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
	CALL W001
; 53: 	Case 2 'police flash
	GOTO L0026
L0007:
	MOVF 0x2D,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0027
; 54: 		led2 = led2 Mod 43
	MOVF 0x33,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x2B
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x33
; 55: 		led1 = led1 Mod 39
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x27
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x32
; 56: 		counter = 0
	CLRF 0x2F
; 57: 		Select Case led1
; 58: 		Case 4, 6, 8, 10, 12, 14, 16, 18
	MOVF 0x32,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0030
	GOTO L0029
L0030:
	MOVF 0x32,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0031
	GOTO L0029
L0031:
	MOVF 0x32,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0032
	GOTO L0029
L0032:
	MOVF 0x32,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0033
	GOTO L0029
L0033:
	MOVF 0x32,W
	SUBLW 0x0C
	BTFSS STATUS,Z
	GOTO L0034
	GOTO L0029
L0034:
	MOVF 0x32,W
	SUBLW 0x0E
	BTFSS STATUS,Z
	GOTO L0035
	GOTO L0029
L0035:
	MOVF 0x32,W
	SUBLW 0x10
	BTFSS STATUS,Z
	GOTO L0036
	GOTO L0029
L0036:
	MOVF 0x32,W
	SUBLW 0x12
	BTFSS STATUS,Z
	GOTO L0028
L0029:
; 59: 			counter.4 = 1
	BSF 0x2F,4
; 60: 		Case 24, 26, 28, 30, 32, 34, 36, 38
	GOTO L0037
L0028:
	MOVF 0x32,W
	SUBLW 0x18
	BTFSS STATUS,Z
	GOTO L0040
	GOTO L0039
L0040:
	MOVF 0x32,W
	SUBLW 0x1A
	BTFSS STATUS,Z
	GOTO L0041
	GOTO L0039
L0041:
	MOVF 0x32,W
	SUBLW 0x1C
	BTFSS STATUS,Z
	GOTO L0042
	GOTO L0039
L0042:
	MOVF 0x32,W
	SUBLW 0x1E
	BTFSS STATUS,Z
	GOTO L0043
	GOTO L0039
L0043:
	MOVF 0x32,W
	SUBLW 0x20
	BTFSS STATUS,Z
	GOTO L0044
	GOTO L0039
L0044:
	MOVF 0x32,W
	SUBLW 0x22
	BTFSS STATUS,Z
	GOTO L0045
	GOTO L0039
L0045:
	MOVF 0x32,W
	SUBLW 0x24
	BTFSS STATUS,Z
	GOTO L0046
	GOTO L0039
L0046:
	MOVF 0x32,W
	SUBLW 0x26
	BTFSS STATUS,Z
	GOTO L0038
L0039:
; 61: 			counter.2 = 1
	BSF 0x2F,2
; 62: 		Case Else
	GOTO L0047
L0038:
; 63: 		EndSelect
L0047:
L0037:
; 64: 		Select Case led2
; 65: 		Case 4, 6, 8, 10, 12, 14, 16, 18, 20
	MOVF 0x33,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0050
	GOTO L0049
L0050:
	MOVF 0x33,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0051
	GOTO L0049
L0051:
	MOVF 0x33,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0052
	GOTO L0049
L0052:
	MOVF 0x33,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0053
	GOTO L0049
L0053:
	MOVF 0x33,W
	SUBLW 0x0C
	BTFSS STATUS,Z
	GOTO L0054
	GOTO L0049
L0054:
	MOVF 0x33,W
	SUBLW 0x0E
	BTFSS STATUS,Z
	GOTO L0055
	GOTO L0049
L0055:
	MOVF 0x33,W
	SUBLW 0x10
	BTFSS STATUS,Z
	GOTO L0056
	GOTO L0049
L0056:
	MOVF 0x33,W
	SUBLW 0x12
	BTFSS STATUS,Z
	GOTO L0057
	GOTO L0049
L0057:
	MOVF 0x33,W
	SUBLW 0x14
	BTFSS STATUS,Z
	GOTO L0048
L0049:
; 66: 			counter.1 = 1
	BSF 0x2F,1
; 67: 		Case 26, 28, 30, 32, 34, 36, 38, 40, 42
	GOTO L0058
L0048:
	MOVF 0x33,W
	SUBLW 0x1A
	BTFSS STATUS,Z
	GOTO L0061
	GOTO L0060
L0061:
	MOVF 0x33,W
	SUBLW 0x1C
	BTFSS STATUS,Z
	GOTO L0062
	GOTO L0060
L0062:
	MOVF 0x33,W
	SUBLW 0x1E
	BTFSS STATUS,Z
	GOTO L0063
	GOTO L0060
L0063:
	MOVF 0x33,W
	SUBLW 0x20
	BTFSS STATUS,Z
	GOTO L0064
	GOTO L0060
L0064:
	MOVF 0x33,W
	SUBLW 0x22
	BTFSS STATUS,Z
	GOTO L0065
	GOTO L0060
L0065:
	MOVF 0x33,W
	SUBLW 0x24
	BTFSS STATUS,Z
	GOTO L0066
	GOTO L0060
L0066:
	MOVF 0x33,W
	SUBLW 0x26
	BTFSS STATUS,Z
	GOTO L0067
	GOTO L0060
L0067:
	MOVF 0x33,W
	SUBLW 0x28
	BTFSS STATUS,Z
	GOTO L0068
	GOTO L0060
L0068:
	MOVF 0x33,W
	SUBLW 0x2A
	BTFSS STATUS,Z
	GOTO L0059
L0060:
; 68: 			counter.0 = 1
	BSF 0x2F,0
; 69: 		Case Else
	GOTO L0069
L0059:
; 70: 		EndSelect
L0069:
L0058:
; 71: 		GPIO = counter
	MOVF 0x2F,W
	MOVWF 0x05
; 72: 		WaitMs 30 'just wait 30 mSecs
	MOVLW 0x1E
	MOVWF R0L
	CLRF R0H
	CALL W001
; 73: 
; 74: 	Case 3 'fire dep. car flashes
	GOTO L0070
L0027:
	MOVF 0x2D,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0071
; 75: 		led1 = led1 Mod 250
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0xFA
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x32
; 76: 		led3 = led3 Mod 245
	MOVF 0x34,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0xF5
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x34
; 77: 		led4 = led4 Mod 241
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0xF1
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x35
; 78: 		counter = 0
	CLRF 0x2F
; 79: 		If led1 < 45 Then
	MOVLW 0x2D
	SUBWF 0x32,W
	BTFSC STATUS,C
	GOTO L0072
; 80: 			counter.4 = 1 '1st led on
	BSF 0x2F,4
; 81: 		Endif
L0072:
; 82: 		If led2 < 45 Then
	MOVLW 0x2D
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0073
; 83: 			counter.2 = 1 '2nd led on
	BSF 0x2F,2
; 84: 		Endif
L0073:
; 85: 		If led3 < 45 Then
	MOVLW 0x2D
	SUBWF 0x34,W
	BTFSC STATUS,C
	GOTO L0074
; 86: 			counter.1 = 1 '3RD led on
	BSF 0x2F,1
; 87: 		Endif
L0074:
; 88: 		If led4 < 45 Then
	MOVLW 0x2D
	SUBWF 0x35,W
	BTFSC STATUS,C
	GOTO L0075
; 89: 			counter.0 = 1 '4TH LED ON
	BSF 0x2F,0
; 90: 		Endif
L0075:
; 91: 		GPIO = counter
	MOVF 0x2F,W
	MOVWF 0x05
; 92: 		WaitUs 1500 'just wait 1,5 mSec
	MOVLW 0xDC
	MOVWF R4L
	MOVLW 0x05
	MOVWF R4H
	CALL Y001
; 93: 
; 94: 	Case 4 'high tower flashes
	GOTO L0076
L0071:
	MOVF 0x2D,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0077
; 95: 		If led1 < 10 Then
	MOVLW 0x0A
	SUBWF 0x32,W
	BTFSC STATUS,C
	GOTO L0078
; 96: 			GPIO = %110111 'all leds On
	MOVLW 0x37
	MOVWF 0x05
; 97: 		Else
	GOTO L0079
L0078:
; 98: 			GPIO = %000000 'all leds off
	CLRF 0x05
; 99: 		Endif
L0079:
; 100: 		WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 101: 	Case 5 'road blockade
	GOTO L0080
L0077:
	MOVF 0x2D,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0081
; 102: 		If led1 > 79 Then
	MOVF 0x32,W
	SUBLW 0x4F
	BTFSC STATUS,C
	GOTO L0082
; 103: 			led1 = 0
	CLRF 0x32
; 104: 		Endif
L0082:
; 105: 		Select Case led1
; 106: 		Case 0
	MOVF 0x32,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0083
; 107: 			GPIO = %010000
	MOVLW 0x10
	MOVWF 0x05
; 108: 			WaitMs 25
	MOVLW 0x19
	MOVWF R0L
	CLRF R0H
	CALL W001
; 109: 			GPIO = %000000
	CLRF 0x05
; 110: 		Case 1
	GOTO L0084
L0083:
	MOVF 0x32,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0085
; 111: 			GPIO = %000100
	MOVLW 0x04
	MOVWF 0x05
; 112: 			WaitMs 25
	MOVLW 0x19
	MOVWF R0L
	CLRF R0H
	CALL W001
; 113: 			GPIO = %000000
	CLRF 0x05
; 114: 		Case 2
	GOTO L0086
L0085:
	MOVF 0x32,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0087
; 115: 			GPIO = %000010
	MOVLW 0x02
	MOVWF 0x05
; 116: 			WaitMs 25
	MOVLW 0x19
	MOVWF R0L
	CLRF R0H
	CALL W001
; 117: 			GPIO = %000000
	CLRF 0x05
; 118: 		Case 3
	GOTO L0088
L0087:
	MOVF 0x32,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0089
; 119: 			GPIO = %000001
	MOVLW 0x01
	MOVWF 0x05
; 120: 			WaitMs 25
	MOVLW 0x19
	MOVWF R0L
	CLRF R0H
	CALL W001
; 121: 			GPIO = %000000
	CLRF 0x05
; 122: 		Case 4
	GOTO L0090
L0089:
	MOVF 0x32,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0091
; 123: 			GPIO = %100000
	MOVLW 0x20
	MOVWF 0x05
; 124: 			WaitMs 25
	MOVLW 0x19
	MOVWF R0L
	CLRF R0H
	CALL W001
; 125: 			GPIO = %000000
	CLRF 0x05
; 126: 		Case Else
	GOTO L0092
L0091:
; 127: 		EndSelect
L0092:
L0090:
L0088:
L0086:
L0084:
; 128: 		WaitMs 25
	MOVLW 0x19
	MOVWF R0L
	CLRF R0H
	CALL W001
; 129: 	Case 6 'traffics lights flash (led 4 and 5)
	GOTO L0093
L0081:
	MOVF 0x2D,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0094
; 130: 		If led1 < 100 Then
	MOVLW 0x64
	SUBWF 0x32,W
	BTFSC STATUS,C
	GOTO L0095
; 131: 			GPIO = %010010
	MOVLW 0x12
	MOVWF 0x05
; 132: 		Else
	GOTO L0096
L0095:
; 133: 			GPIO = %000101
	MOVLW 0x05
	MOVWF 0x05
; 134: 		Endif
L0096:
; 135: 		WaitMs 4
	MOVLW 0x04
	MOVWF R0L
	CLRF R0H
	CALL W001
; 136: 	Case 7, 8 'traffic lights dutch and german pattern
	GOTO L0097
L0094:
	MOVF 0x2D,W
	SUBLW 0x07
	BTFSS STATUS,Z
	GOTO L0100
	GOTO L0099
L0100:
	MOVF 0x2D,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0098
L0099:
; 137: 		Select Case led1
; 138: 		Case 1 'red
	MOVF 0x32,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0101
; 139: 			GPIO = %010000
	MOVLW 0x10
	MOVWF 0x05
; 140: 		Case 10, 11 'yellow
	GOTO L0102
L0101:
	MOVF 0x32,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0105
	GOTO L0104
L0105:
	MOVF 0x32,W
	SUBLW 0x0B
	BTFSS STATUS,Z
	GOTO L0103
L0104:
; 141: 			If program = 8 Then 'german
	MOVF 0x2D,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0106
; 142: 				GPIO = %010100
	MOVLW 0x14
	MOVWF 0x05
; 143: 			Else 'dutch
	GOTO L0107
L0106:
; 144: 				GPIO = %000100
	MOVLW 0x04
	MOVWF 0x05
; 145: 			Endif
L0107:
; 146: 		Case 12 'green
	GOTO L0108
L0103:
	MOVF 0x32,W
	SUBLW 0x0C
	BTFSS STATUS,Z
	GOTO L0109
; 147: 			GPIO = %000010
	MOVLW 0x02
	MOVWF 0x05
; 148: 		Case 21 'yellow
	GOTO L0110
L0109:
	MOVF 0x32,W
	SUBLW 0x15
	BTFSS STATUS,Z
	GOTO L0111
; 149: 			GPIO = %000100
	MOVLW 0x04
	MOVWF 0x05
; 150: 		Case 22
	GOTO L0112
L0111:
	MOVF 0x32,W
	SUBLW 0x16
	BTFSS STATUS,Z
	GOTO L0113
; 151: 			led1 = 0
	CLRF 0x32
; 152: 		Case Else
	GOTO L0114
L0113:
; 153: 		EndSelect
L0114:
L0112:
L0110:
L0108:
L0102:
; 154: 		WaitMs 1500
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	CALL W001
; 155: 	Case 9 'red and white flashes for railroad crossing
	GOTO L0115
L0098:
	MOVF 0x2D,W
	SUBLW 0x09
	BTFSS STATUS,Z
	GOTO L0116
; 156: 		If GPIO.5 = 0 Then 'red flashes need to be activated
	BTFSC 0x05,5
	GOTO L0117
; 157: 			led1 = led1 Mod 12
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0C
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x32
; 158: 			If led1 < 6 Then
	MOVLW 0x06
	SUBWF 0x32,W
	BTFSC STATUS,C
	GOTO L0118
; 159: 				GPIO = %000100
	MOVLW 0x04
	MOVWF 0x05
; 160: 			Else
	GOTO L0119
L0118:
; 161: 				GPIO = %000010
	MOVLW 0x02
	MOVWF 0x05
; 162: 			Endif
L0119:
; 163: 			WaitMs 50
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 164: 		Else
	GOTO L0120
L0117:
; 165: 			led1 = led1 Mod 20
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x14
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x32
; 166: 			If led1 = 0 Then
	MOVF 0x32,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0121
; 167: 				GPIO = %010000
	MOVLW 0x10
	MOVWF 0x05
; 168: 			Else
	GOTO L0122
L0121:
; 169: 				GPIO = %000000
	CLRF 0x05
; 170: 			Endif
L0122:
; 171: 		Endif
L0120:
; 172: 		WaitMs 100
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
	CALL W001
; 173: 	Case 10 'railroad crossing for German system.
	GOTO L0123
L0116:
	MOVF 0x2D,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0124
; 174: 		If GPIO.5 = 0 Then
	BTFSC 0x05,5
	GOTO L0125
; 175: 			If program_enable = 0 Then
	BTFSC 0x2C,0
	GOTO L0126
; 176: 				GPIO = %110000 'Orange led on
	MOVLW 0x30
	MOVWF 0x05
; 177: 				WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 178: 				GPIO = %100100 'red led on
	MOVLW 0x24
	MOVWF 0x05
; 179: 				WaitMs 6000
	MOVLW 0x70
	MOVWF R0L
	MOVLW 0x17
	MOVWF R0H
	CALL W001
; 180: 				GPIO = %100110 'red led + command for 1st barrier to go down.
	MOVLW 0x26
	MOVWF 0x05
; 181: 				WaitMs 6000
	MOVLW 0x70
	MOVWF R0L
	MOVLW 0x17
	MOVWF R0H
	CALL W001
; 182: 				GPIO = %100111 'red led + 1st and second barrier down
	MOVLW 0x27
	MOVWF 0x05
; 183: 				program_enable = 1 'this sequence only once
	BSF 0x2C,0
; 184: 			Endif
L0126:
; 185: 		Else
	GOTO L0127
L0125:
; 186: 			If program_enable = 1 Then
	BTFSS 0x2C,0
	GOTO L0128
; 187: 				GPIO = %100100 'barriers up and red led on
	MOVLW 0x24
	MOVWF 0x05
; 188: 				WaitMs 6000
	MOVLW 0x70
	MOVWF R0L
	MOVLW 0x17
	MOVWF R0H
	CALL W001
; 189: 				GPIO = %100000 'led off
	MOVLW 0x20
	MOVWF 0x05
; 190: 				program_enable = 0 'this sequence only once
	BCF 0x2C,0
; 191: 			Endif
L0128:
; 192: 		Endif
L0127:
; 193: 
; 194: 	Case Else 'led 1 makes simulation of welding flashes. also useable as TV simulation
	GOTO L0129
L0124:
; 195: 		For counter = 0 To 29
	CLRF 0x2F
L0130:
	MOVF 0x2F,W
	SUBLW 0x1D
	BTFSS STATUS,C
	GOTO L0131
; 196: 			counter2 = counter + result
	MOVF 0x2F,W
	ADDWF 0x31,W
	MOVWF 0x30
; 197: 			While counter2 > 29
L0132:
	MOVF 0x30,W
	SUBLW 0x1D
	BTFSC STATUS,C
	GOTO L0133
; 198: 				counter2 = counter2 - 29
	MOVLW 0x1D
	SUBWF 0x30,W
	MOVWF 0x30
; 199: 			Wend
	GOTO L0132
L0133:
; 200: 			on_time = LookUp(2, 14, 13, 6, 8, 15, 2, 22, 18, 3, 9, 11, 17, 4, 7, 21, 12, 4, 6, 6, 18, 3, 18, 14, 15, 16, 4, 8, 9, 7), counter
	MOVF 0x2F,W
	SUBLW 0x1D
	BTFSS STATUS,C
	GOTO L0134
	CALL L0135
	MOVWF 0x36
	GOTO L0134
L0135:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x2F,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x0E
	RETLW 0x0D
	RETLW 0x06
	RETLW 0x08
	RETLW 0x0F
	RETLW 0x02
	RETLW 0x16
	RETLW 0x12
	RETLW 0x03
	RETLW 0x09
	RETLW 0x0B
	RETLW 0x11
	RETLW 0x04
	RETLW 0x07
	RETLW 0x15
	RETLW 0x0C
	RETLW 0x04
	RETLW 0x06
	RETLW 0x06
	RETLW 0x12
	RETLW 0x03
	RETLW 0x12
	RETLW 0x0E
	RETLW 0x0F
	RETLW 0x10
	RETLW 0x04
	RETLW 0x08
	RETLW 0x09
	RETLW 0x07
L0134:
; 201: 			off_time = LookUp(9, 11, 17, 4, 7, 21, 22, 4, 6, 6, 13, 3, 18, 3, 18, 14, 11, 16, 4, 8, 9, 2, 24, 13, 6, 8, 15, 2, 12, 18), counter2
	MOVF 0x30,W
	SUBLW 0x1D
	BTFSS STATUS,C
	GOTO L0136
	CALL L0137
	MOVWF 0x37
	GOTO L0136
L0137:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x30,W
	ADDWF PCL,F
	RETLW 0x09
	RETLW 0x0B
	RETLW 0x11
	RETLW 0x04
	RETLW 0x07
	RETLW 0x15
	RETLW 0x16
	RETLW 0x04
	RETLW 0x06
	RETLW 0x06
	RETLW 0x0D
	RETLW 0x03
	RETLW 0x12
	RETLW 0x03
	RETLW 0x12
	RETLW 0x0E
	RETLW 0x0B
	RETLW 0x10
	RETLW 0x04
	RETLW 0x08
	RETLW 0x09
	RETLW 0x02
	RETLW 0x18
	RETLW 0x0D
	RETLW 0x06
	RETLW 0x08
	RETLW 0x0F
	RETLW 0x02
	RETLW 0x0C
	RETLW 0x12
L0136:
; 202: 			on_time = on_time * 10
	MOVF 0x36,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVWF 0x36
; 203: 			off_time = off_time * 10
	MOVF 0x37,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVWF 0x37
; 204: 			If on_time > 13 Then
	MOVF 0x36,W
	SUBLW 0x0D
	BTFSC STATUS,C
	GOTO L0138
; 205: 				GPIO = %011001
	MOVLW 0x19
	MOVWF 0x05
; 206: 			Else
	GOTO L0139
L0138:
; 207: 				GPIO = %011000
	MOVLW 0x18
	MOVWF 0x05
; 208: 			Endif
L0139:
; 209: 			WaitMs on_time
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 210: 			If counter2 > 13 Then
	MOVF 0x30,W
	SUBLW 0x0D
	BTFSC STATUS,C
	GOTO L0140
; 211: 				GPIO = %001010
	MOVLW 0x0A
	MOVWF 0x05
; 212: 			Else
	GOTO L0141
L0140:
; 213: 				GPIO = %001000
	MOVLW 0x08
	MOVWF 0x05
; 214: 			Endif
L0141:
; 215: 			WaitMs off_time
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 216: 			If GPIO.3 = 0 Then
	BTFSC 0x05,3
	GOTO L0142
; 217: 				counter = 29
	MOVLW 0x1D
	MOVWF 0x2F
; 218: 			Endif
L0142:
; 219: 		Next counter
	MOVLW 0x01
	ADDWF 0x2F,F
	BTFSS STATUS,C
	GOTO L0130
L0131:
; 220: 	EndSelect
L0129:
L0123:
L0115:
L0097:
L0093:
L0080:
L0076:
L0070:
L0026:
; 221: 	If GPIO.3 = 0 Then
	BTFSC 0x05,3
	GOTO L0143
; 222: 		GPIO = %000000
	CLRF 0x05
; 223: 		program = program + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 224: 		If program > maxprogram Then
	MOVF 0x2D,W
	SUBLW 0x0B
	BTFSC STATUS,C
	GOTO L0144
; 225: 			program = 1
	MOVLW 0x01
	MOVWF 0x2D
; 226: 		Endif
L0144:
; 227: 		Call set_ports(program)
	MOVF 0x2D,W
	MOVWF 0x38
	CALL L0002
; 228: 		Write 0, program
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x2D,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0145:	BTFSC EECON1,WR
	GOTO L0145
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 229: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	CALL W001
; 230: 		While GPIO.3 = 0
L0146:
	BTFSC 0x05,3
	GOTO L0147
; 231: 			WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	CALL W001
; 232: 		Wend
	GOTO L0146
L0147:
; 233: 		led1 = 0
	CLRF 0x32
; 234: 		led2 = 0
	CLRF 0x33
; 235: 	Endif
L0143:
; 236: Wend
	GOTO L0005
L0006:
; 237: 
; 238: End
L0148:	GOTO L0148
; 239: 
; 240: Proc set_ports(program As Byte)
L0002:
; 241: 	Select Case program
; 242: 	Case 9, 10
	MOVF 0x38,W
	SUBLW 0x09
	BTFSS STATUS,Z
	GOTO L0151
	GOTO L0150
L0151:
	MOVF 0x38,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0149
L0150:
; 243: 		TRISIO = %101000 'gpio5 is need for input
	BSF STATUS,RP0
	MOVLW 0x28
	MOVWF 0x05
; 244: 		WPU.5 = 1 'set internal weak pull-up
	BSF 0x15,5
	BCF STATUS,RP0
; 245: 	Case Else
	GOTO L0152
L0149:
; 246: 		TRISIO = %001000
	BSF STATUS,RP0
	MOVLW 0x08
	MOVWF 0x05
; 247: 		WPU.5 = 0
	BCF 0x15,5
	BCF STATUS,RP0
; 248: 	EndSelect
L0152:
; 249: 
; 250: End Proc
	RETURN
; End of program
L0153:	GOTO L0153
; Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	MOVF R2L,W
	RETURN
; Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	MOVF R0L,W
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine - Word Argument
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Configuration word settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
